/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2216;

import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.Icon;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm2216.BoxGraphic;
import ibm.nways.jdm2216.ConfirmationBox;
import ibm.nways.jdm2216.DeviceGraphicInfo;
import ibm.nways.jdm2216.Fast2216Model;
import ibm.nways.jdm2216.GraphicSlotContainer;
import ibm.nways.jdm2216.StatusPipe2216Impl;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BoxGraphic {
    private GenModel systemModel;
    private GenModel interfaceModel;
    private JdmBrowser jdm2216Browser;
    private GraphicSlotContainer slotContainer;
    private static ResourceBundle jdm2216Bundle = null;
    private Thread getSlots;
    private Thread reCheckStatus;
    private static final String PropertiesFile = "properties/jdm2216.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    private ModelInfo pciAdapInfo;
    private Icon statusIcon;
    GenModel jdm2216model;
    Hashtable statusIndexes;

    protected BoxGraphic(JdmBrowser jdmBrowser) {
        this.jdm2216Browser = jdmBrowser;
    }

    protected GraphicPanel getGraphicPanel() {
        Object object;
        Object object2;
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        try {
            serializable = new URL(this.jdm2216Browser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            System.out.println("Error getting Jdm2216 Properties: " + exception.getMessage());
            properties = null;
            exception.printStackTrace();
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2216Browser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            object2 = (String)((Hashtable)properties).get(fractKey);
            object = new StringTokenizer((String)object2);
            float[] fArray = new float[((StringTokenizer)object).countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                try {
                    fArray[n2] = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        if (jdm2216Bundle == null) {
            jdm2216Bundle = ResourceBundle.getBundle("ibm.nways.jdm2216.Resources");
        }
        serializable = new Point(20, 20);
        object2 = null;
        try {
            this.systemModel = (GenModel)this.jdm2216model.getComponent("System");
            object2 = new GraphicActionNavigate(this.jdm2216Browser, new NavigationDestination("ibm.nways.mib2.SystemInfoPanel", this.systemModel), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GraphicImage graphicImage = new GraphicImage(this.jdm2216Browser.imageFrom(this, "jdm2216.gif"), (Point)serializable, 3, (GraphicAction)object2, null);
        graphicContainer.add(graphicImage);
        object = new GraphicHelp(this.jdm2216Browser, new Point(0, 0), new HelpRef(this));
        graphicContainer.add((GraphicComponent)object);
        this.slotContainer = new GraphicSlotContainer(this.jdm2216Browser, (Point)serializable);
        if (this.getSlots != null) {
            this.getSlots.stop();
        }
        this.statusIndexes = new Hashtable(30);
        this.getSlots = new 1();
        this.getSlots.start();
        graphicContainer.add((Component)this.slotContainer, 0);
        GraphicPanel graphicPanel = new GraphicPanel(this.jdm2216Browser, graphicContainer);
        return graphicPanel;
    }

    public void showSlotContainer() {
        if (this.slotContainer != null) {
            this.slotContainer.showCards();
        }
    }

    public void stopThreads() {
        if (this.getSlots != null && this.getSlots.isAlive()) {
            this.getSlots.stop();
        }
        if (this.reCheckStatus != null && this.reCheckStatus.isAlive()) {
            this.reCheckStatus.stop();
        }
        if (this.statusIcon != null) {
            this.jdm2216Browser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
        }
    }

    void predetermineAllSlots() {
        if (this.pciAdapInfo == null) {
            return;
        }
        try {
            int n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType1");
            int n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(1, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType2");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(2, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType3");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(3, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType4");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(4, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType5");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(5, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType6");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(6, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType7");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(7, n2);
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType8");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(8, n2);
            this.showSlotContainer();
            return;
        }
        catch (Exception exception) {
            System.out.println("Error getting PciAdapter element");
            exception.printStackTrace();
            return;
        }
    }

    public void gotOne(DeviceGraphicInfo deviceGraphicInfo) {
        Integer n = new Integer(deviceGraphicInfo.index);
        this.statusIndexes.put(n, n);
        StatusAttachThread statusAttachThread = new StatusAttachThread(deviceGraphicInfo);
        statusAttachThread.start();
    }

    public void processOne(DeviceGraphicInfo deviceGraphicInfo) {
        StatusProxy statusProxy = new StatusProxy(deviceGraphicInfo.status);
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.IfIndex", new Integer(deviceGraphicInfo.index));
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        navigationContext.setParent(this.jdm2216Browser.getNavigationTree().getNavContext());
        GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.jdm2216Browser, new NavigationDestination("ibm.nways.mib2.eui.Mib2InterfacesPanel", this.interfaceModel), navigationContext);
        int n = this.determineSlotType(deviceGraphicInfo.type, deviceGraphicInfo.speed);
        this.slotContainer.addSlot(deviceGraphicInfo.slot, deviceGraphicInfo.port, statusProxy, graphicActionNavigate, n);
    }

    void determineAllSlots() {
        new Vector();
        this.statusIcon = new Icon(this.jdm2216Browser.imageFrom(this, "statusAnimation.gif"));
        this.statusIcon.setFlyOver(new GraphicFlyOver(jdm2216Bundle.getString("RetrievingStatus")));
        this.jdm2216Browser.addTrayIcon(this.statusIcon);
        try {
            this.interfaceModel = (GenModel)this.jdm2216model.getComponent("Interface");
            StatusPipe2216Impl statusPipe2216Impl = new StatusPipe2216Impl(this);
            Fast2216Model fast2216Model = (Fast2216Model)this.jdm2216model.getComponent("HandCodedFast2216");
            Integer n = fast2216Model.getDeviceGraphicInfo(statusPipe2216Impl);
            statusPipe2216Impl.dispose();
            if (n.intValue() != this.statusIndexes.size()) {
                throw new RemoteException();
            }
            this.showSlotContainer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            2 var2_4 = new 2();
            ConfirmationBox confirmationBox = new ConfirmationBox(this.jdm2216Browser.getFrame(), jdm2216Bundle.getString("ConfimationBox Title"), jdm2216Bundle.getString("GraphicError"), var2_4);
            confirmationBox.show();
        }
        this.jdm2216Browser.removeTrayIcon(this.statusIcon);
        this.statusIcon.getImage().flush();
        this.statusIcon = null;
    }

    protected Thread getReCheckStatusThread() {
        return this.reCheckStatus;
    }

    protected void setReCheckStatusThread(Thread thread) {
        this.reCheckStatus = thread;
    }

    int determineSlotType(int n, long l) {
        int n2 = 0;
        switch (n) {
            case 37: {
                n2 = 10;
                break;
            }
            case 18: {
                if (l == 1544000L) {
                    n2 = 4;
                    break;
                }
                n2 = 5;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 33: {
                n2 = 7;
                break;
            }
            case 45: 
            case 65: {
                n2 = 8;
                break;
            }
            case 73: {
                n2 = 11;
                break;
            }
            case 15: {
                n2 = 12;
                break;
            }
            case 46: {
                n2 = 14;
                break;
            }
            case 62: {
                n2 = 15;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    int mapPciSlotType(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 10;
                break;
            }
            case 9: {
                n2 = 4;
                break;
            }
            case 10: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
            case 13: {
                n2 = 6;
                break;
            }
            case 11: {
                n2 = 7;
                break;
            }
            case 12: {
                n2 = 8;
                break;
            }
            case 8: {
                n2 = 11;
                break;
            }
            case 17: {
                n2 = 12;
                break;
            }
            case 16: {
                n2 = 14;
                break;
            }
            case 15: {
                n2 = 15;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected void setJdm2216Model(GenModel genModel) {
        this.jdm2216model = genModel;
    }

    protected void setPciAdapInfo(ModelInfo modelInfo) {
        this.pciAdapInfo = modelInfo;
    }

    private final class 1
    extends Thread {
        public void run() {
            this.setPriority(this.getPriority() + 1);
            BoxGraphic.this.predetermineAllSlots();
            BoxGraphic.this.determineAllSlots();
        }

        /* synthetic */ 1() {
        }
    }

    class StatusAttachThread
    extends Thread {
        DeviceGraphicInfo devInfo;

        public StatusAttachThread(DeviceGraphicInfo deviceGraphicInfo) {
            BoxGraphic.this = BoxGraphic.this;
            this.devInfo = deviceGraphicInfo;
        }

        public void run() {
            BoxGraphic.this.processOne(this.devInfo);
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BoxGraphic.this.getReCheckStatusThread() != null) {
                BoxGraphic.this.getReCheckStatusThread().stop();
                BoxGraphic.this.setReCheckStatusThread(null);
            }
            3 var2_2 = new 3(BoxGraphic.this);
            BoxGraphic.this.setReCheckStatusThread(var2_2);
            BoxGraphic.this.getReCheckStatusThread().start();
        }

        /* synthetic */ 2() {
        }
    }
}

